main()
{
    CDIR=${HOME}
    RAND_DIR=$1
    MPASSWD=$2
    WORK_DIR=${CDIR}/DESKTOPCLIENT_DBUILD/DESKTOPCLIENT_PARALLEL/${RAND_DIR}
    OUTPUT_DIR=${WORK_DIR}/mac_app/output
    APP_DIR=${WORK_DIR}/DESKTOPCLIENT_APPDBUILD/
    export path
    ##NODE_PATH=/Users/ios_build/.nvm/versions/node/v6.11.0/
    #PATH=${NODE_PATH}/bin:${PATH}
    #node --version    
    APP_PATH=${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app
    RESULT_PATH=release/pkg/ZohoSalesIQ.pkg
    APP_KEY="EB7C393FC8872A3C7B6EFA365CC4055924A80817"
    INSTALLER_KEY="06AE1030761202EEC02FB08B462F0012A96C1D9C"
    productDir=`pwd`
    CHILD_PLIST="./child.plist"
    PARENT_PLIST="./parent.plist"
    
#    CREATE_APP > $APP_DIR/app.out 2>&1
#    cat $APP_DIR/app.out
    CREATE_APP

}
CREATE_APP()
{
    unzip -d DESKTOPCLIENT_APPDBUILD desktopclient_mac.zip
    cd DESKTOPCLIENT_APPDBUILD/
    find . -name "child.plist"
    sh -x shell/install.sh
    mkdir -p ${WORK_DIR}/mac_app/output
    cp -r ${APP_DIR}/ZohoSalesIQ-mas-x64 ${OUTPUT_DIR}/

    mv ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/ReactiveCocoa.framework/ ${WORK_DIR}/ReactiveCocoa
    mv ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/Electron\ Framework.framework/ ${WORK_DIR}/Electron
    mv ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/Mantle.framework/ ${WORK_DIR}/Mantle
    mv ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/Squirrel.framework/ ${WORK_DIR}/Squirrel

    cp -r ${WORK_DIR}/ReactiveCocoa/Versions/A/   ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/ReactiveCocoa.framework/
    cp -r ${WORK_DIR}/Electron/Versions/A/ ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/Electron\ Framework.framework/
    cp -r ${WORK_DIR}/Mantle/Versions/A/ ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/Mantle.framework/
    cp -r ${WORK_DIR}/Squirrel/Versions/A/ ${OUTPUT_DIR}/ZohoSalesIQ-mas-x64/ZohoSalesIQ.app/Contents/Frameworks/Squirrel.framework/

    sed -i '' -e 's/<key>CFBundleIconFile<\/key>/<key>ElectronTeamID<\/key>\
    <string>TZ824L8Y37<\/string>\
    <key>CFBundleIconFile<\/key>/' "$APP_PATH/Contents/Info.plist"
    cat "$APP_PATH/Contents/Info.plist"

    export CODESIGN_ALLOCATE="/Applications/Xcode.app/Contents/Developer/Toolchains/XcodeDefault.xctoolchain/usr/bin/codesign_allocate"
    
    
    
    codesign --deep --force --verify --verbose --sign "$APP_KEY" "$APP_PATH/Contents/Frameworks/Electron Framework.framework/Electron Framework"
    
    echo "### signing app"
    codesign --deep --force --verify --verbose --sign "$APP_KEY" "$APP_PATH"

    echo "### verifying signature",
    codesign -vv --deep-verify  "$APP_PATH"
    
    codesign -dvv "$APP_PATH"
    
    spctl -a -vvvv "$APP_PATH" 
    
    FRAMEWORKS_PATH="$APP_PATH/Contents/Frameworks"



    cat "$CHILD_PLIST"
    cat "$PARENT_PLIST"


    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/Electron Framework.framework/Electron Framework"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/Electron Framework.framework/Libraries/libffmpeg.dylib"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/Electron Framework.framework/Libraries/libnode.dylib"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/Electron Framework.framework"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/ZohoSalesIQ Helper.app/Contents/MacOS/ZohoSalesIQ Helper"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/ZohoSalesIQ Helper.app/"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/ZohoSalesIQ Helper EH.app/Contents/MacOS/ZohoSalesIQ Helper EH"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/ZohoSalesIQ Helper EH.app/"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/ZohoSalesIQ Helper NP.app/Contents/MacOS/ZohoSalesIQ Helper NP"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$FRAMEWORKS_PATH/ZohoSalesIQ Helper NP.app/"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$CHILD_PLIST" "$APP_PATH/Contents/MacOS/ZohoSalesIQ"
    codesign --verbose -s "$APP_KEY" -f --entitlements "$PARENT_PLIST" "$APP_PATH"
    
    
    
    
    
    mkdir release
    
    mkdir release/pkg
    
    productbuild --component "$APP_PATH" /Applications --sign "$INSTALLER_KEY" "$RESULT_PATH"

    
    ditto release ${OUTPUT_DIR}/
    
    
#    cp -r $APP_DIR/app.out ${OUTPUT_DIR}/
    cd ${OUTPUT_DIR}
    zip -ry desktopclient_op_app.zip  .

}
main $*
